<?php
// public/tracked-coins.php

require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/Database.php';

requireLogin();

$userId = $_SESSION['user_id'];
$db = Database::getInstance();
$trackedCoins = $db->getTrackedCoins($userId);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tracked Coins - Binance Futures Alert System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <nav class="navbar">
        <div class="nav-brand">Binance Futures Alerts</div>
        <div class="nav-menu">
            <a href="dashboard.php">Dashboard</a>
            <a href="alerts.php">Alerts</a>
            <a href="tracked-coins.php" class="active">Tracked Coins</a>
            <a href="settings.php">Settings</a>
            <a href="logout.php">Logout (<?php echo htmlspecialchars($_SESSION['username']); ?>)</a>
        </div>
    </nav>
    
    <div class="container">
        <h1>Tracked Coins</h1>
        
        <div class="action-buttons">
            <button class="btn btn-primary" id="addCoinBtn">Add New Coin</button>
        </div>
        
        <?php if (empty($trackedCoins)): ?>
            <div class="no-data">
                You are not tracking any coins yet. Click "Add New Coin" to start tracking.
            </div>
        <?php else: ?>
            <table class="coins-table">
                <thead>
                    <tr>
                        <th>Symbol</th>
                        <th>Price</th>
                        <th>Volume 24h</th>
                        <th>Trend</th>
                        <th>Price Action</th>
                        <th>Support Levels</th>
                        <th>Resistance Levels</th>
                        <th>Last Update</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($trackedCoins as $coin): ?>
                    <tr>
                        <td class="symbol"><?php echo htmlspecialchars($coin['symbol']); ?></td>
                        <td class="price">$<?php echo formatPrice($coin['current_price']); ?></td>
                        <td><?php echo formatVolume($coin['volume_24h']); ?></td>
                        <td>
                            <span class="trend trend-<?php echo $coin['trend'] ?: 'neutral'; ?>">
                                <?php echo ucfirst($coin['trend'] ?: 'neutral'); ?>
                            </span>
                        </td>
                        <td><?php echo ucfirst($coin['price_action'] ?: 'consolidation'); ?></td>
                        <td>
                            <?php foreach ($coin['supportLevels'] as $level): ?>
                                <div>$<?php echo formatPrice($level['level']); ?></div>
                            <?php endforeach; ?>
                        </td>
                        <td>
                            <?php foreach ($coin['resistanceLevels'] as $level): ?>
                                <div>$<?php echo formatPrice($level['level']); ?></div>
                            <?php endforeach; ?>
                        </td>
                        <td><?php echo formatTimeAgo($coin['last_update']); ?></td>
                        <td>
                            <button class="btn btn-danger btn-sm remove-coin" data-symbol="<?php echo $coin['symbol']; ?>">
                                Remove
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <!-- Add Coin Modal -->
    <div class="modal" id="addCoinModal" style="display: none;">
        <div class="modal-content">
            <h2>Add Coin to Track</h2>
            <form id="addCoinForm">
                <div class="form-group">
                    <label>Symbol (e.g., BTCUSDT)</label>
                    <input type="text" name="symbol" required placeholder="BTCUSDT">
                </div>
                <div class="form-actions">
                    <button type="button" class="btn btn-secondary" id="cancelAddCoin">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </form>
        </div>
    </div>
    
    <style>
    .modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
    }
    
    .modal-content {
        background: white;
        padding: 30px;
        border-radius: 8px;
        width: 100%;
        max-width: 400px;
    }
    
    .btn-sm {
        padding: 4px 8px;
        font-size: 12px;
    }
    </style>
    
    <script>
    document.getElementById('addCoinBtn').addEventListener('click', () => {
        document.getElementById('addCoinModal').style.display = 'flex';
    });
    
    document.getElementById('cancelAddCoin').addEventListener('click', () => {
        document.getElementById('addCoinModal').style.display = 'none';
    });
    
    document.getElementById('addCoinForm').addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const formData = new FormData(e.target);
        
        try {
            const response = await fetch('api/get_data.php?action=add_tracked_coin', {
                method: 'POST',
                body: formData
            });
            
            const data = await response.json();
            
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + (data.error || 'Unknown error'));
            }
        } catch (error) {
            alert('Error: ' + error.message);
        }
    });
    
    document.querySelectorAll('.remove-coin').forEach(btn => {
        btn.addEventListener('click', async () => {
            if (!confirm('Remove this coin from tracking?')) return;
            
            const symbol = btn.dataset.symbol;
            const formData = new FormData();
            formData.append('symbol', symbol);
            
            try {
                const response = await fetch('api/get_data.php?action=remove_tracked_coin', {
                    method: 'POST',
                    body: formData
                });
                
                const data = await response.json();
                
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (data.error || 'Unknown error'));
                }
            } catch (error) {
                alert('Error: ' + error.message);
            }
        });
    });
    </script>
</body>
</html>