<?php
// public/register.php

session_start();
require_once __DIR__ . '/../includes/functions.php';

if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
    
    if ($password !== $confirm) {
        $error = 'Passwords do not match';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters';
    } else {
        require_once __DIR__ . '/../config/database.php';
        
        // Check if username exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$username, $email]);
        
        if ($stmt->fetch()) {
            $error = 'Username or email already exists';
        } else {
            // Create user
            $hash = hashPassword($password);
            $stmt = $pdo->prepare("INSERT INTO users (username, email, password_hash) VALUES (?, ?, ?)");
            
            if ($stmt->execute([$username, $email, $hash])) {
                $userId = $pdo->lastInsertId();
                
                // Create default settings
                $stmt = $pdo->prepare("INSERT INTO user_settings (user_id) VALUES (?)");
                $stmt->execute([$userId]);
                
                // Insert default alert types
                $defaultTypes = [
                    'rsi', 'price', 'support', 'orderbook', 'liquidation',
                    'multi', 'volume', 'funding', 'oi_change', 'whale',
                    'breakout', 'second_rejection', 'two_percent_drop',
                    'buying_spike', 'selling_spike', 'accumulation',
                    'distribution', 'volume_climax', 'pattern'
                ];
                
                $stmt = $pdo->prepare("INSERT INTO alert_types_enabled (user_id, alert_type, enabled) VALUES (?, ?, 1)");
                foreach ($defaultTypes as $type) {
                    $stmt->execute([$userId, $type]);
                }
                
                $success = 'Registration successful! You can now login.';
            } else {
                $error = 'Registration failed';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Register - Binance Futures Alert System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="auth-container">
        <div class="auth-box">
            <h1>Register</h1>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" name="username" required>
                </div>
                
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" required>
                </div>
                
                <div class="form-group">
                    <label>Password (min. 6 characters)</label>
                    <input type="password" name="password" required>
                </div>
                
                <div class="form-group">
                    <label>Confirm Password</label>
                    <input type="password" name="confirm_password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">Register</button>
            </form>
            
            <p class="text-center">Already have an account? <a href="login.php">Login</a></p>
            <p class="text-center"><a href="index.php">← Back to Home</a></p>
        </div>
    </div>
</body>
</html>