<?php
// public/index.php - Landing page

session_start();

if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Binance Futures Alert System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="landing-container">
        <div class="landing-header">
            <h1>📊 Binance Futures Alert System</h1>
            <p>Real-time monitoring and alerts for Binance Futures</p>
        </div>
        
        <div class="landing-buttons">
            <a href="login.php" class="btn btn-primary">Login</a>
            <a href="register.php" class="btn btn-secondary">Register</a>
        </div>
        
        <div class="features">
            <div class="feature">
                <div class="feature-icon">📈</div>
                <h3>RSI Alerts</h3>
                <p>Monitor RSI 7 on 15m and 1D timeframes</p>
            </div>
            <div class="feature">
                <div class="feature-icon">💰</div>
                <h3>Liquidations</h3>
                <p>Track large liquidation events</p>
            </div>
            <div class="feature">
                <div class="feature-icon">📊</div>
                <h3>Order Book</h3>
                <p>Analyze order book imbalance</p>
            </div>
            <div class="feature">
                <div class="feature-icon">🐋</div>
                <h3>Whale Alerts</h3>
                <p>Detect large orders</p>
            </div>
            <div class="feature">
                <div class="feature-icon">📉</div>
                <h3>Volume Spikes</h3>
                <p>Identify buying/selling pressure</p>
            </div>
            <div class="feature">
                <div class="feature-icon">📧</div>
                <h3>Email Alerts</h3>
                <p>Get alerts via email</p>
            </div>
        </div>
    </div>
</body>
</html>