<?php
// public/dashboard.php

require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/Database.php';

requireLogin();

$userId = $_SESSION['user_id'];
$db = Database::getInstance();

// Get user settings
$settings = $db->getUserSettings($userId);

// Get recent alerts
$alerts = $db->getRecentAlerts($userId, 50);

// Get tracked coins
$trackedCoins = $db->getTrackedCoins($userId);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Dashboard - Binance Futures Alert System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <nav class="navbar">
        <div class="nav-brand">Binance Futures Alerts</div>
        <div class="nav-menu">
            <a href="dashboard.php" class="active">Dashboard</a>
            <a href="alerts.php">Alerts</a>
            <a href="tracked-coins.php">Tracked Coins</a>
            <a href="settings.php">Settings</a>
            <a href="logout.php">Logout (<?php echo htmlspecialchars($_SESSION['username']); ?>)</a>
        </div>
    </nav>
    
    <div class="container">
        <h1>Dashboard</h1>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-value"><?php echo count($alerts); ?></div>
                <div class="stat-label">Recent Alerts</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo count($trackedCoins); ?></div>
                <div class="stat-label">Tracked Coins</div>
            </div>
            <div class="stat-card">
                <div class="stat-value" id="rsiSymbols">Loading...</div>
                <div class="stat-label">RSI Symbols</div>
            </div>
            <div class="stat-card">
                <div class="stat-value" id="lastUpdate">-</div>
                <div class="stat-label">Last Update</div>
            </div>
        </div>
        
        <div class="action-buttons">
            <button class="btn btn-primary" id="analyzeNow">Analyze Now</button>
            <a href="tracked-coins.php" class="btn btn-secondary">Manage Tracked Coins</a>
            <a href="settings.php" class="btn btn-secondary">Settings</a>
        </div>
        
        <div class="recent-alerts">
            <h2>Recent Alerts</h2>
            
            <?php if (empty($alerts)): ?>
                <div class="no-data">No alerts yet</div>
            <?php else: ?>
                <?php foreach ($alerts as $alert): ?>
                    <div class="alert-item">
                        <div class="alert-header">
                            <span class="alert-type <?php echo $alert['alert_type']; ?>">
                                <?php echo strtoupper($alert['alert_type']); ?>
                            </span>
                            <span class="alert-time"><?php echo formatTimeAgo($alert['created_at']); ?></span>
                        </div>
                        <div class="alert-symbol"><?php echo htmlspecialchars($alert['symbol']); ?></div>
                        <div class="alert-title"><?php echo htmlspecialchars($alert['title']); ?></div>
                        <div class="alert-message"><?php echo nl2br(htmlspecialchars($alert['message'])); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
    document.getElementById('analyzeNow').addEventListener('click', async () => {
        const btn = document.getElementById('analyzeNow');
        btn.disabled = true;
        btn.textContent = 'Analyzing...';
        
        try {
            const response = await fetch('api/get_data.php?action=analyze');
            const data = await response.json();
            
            if (data.success) {
                alert('Analysis completed successfully!');
                location.reload();
            } else {
                alert('Analysis failed: ' + (data.error || 'Unknown error'));
            }
        } catch (error) {
            alert('Error: ' + error.message);
        } finally {
            btn.disabled = false;
            btn.textContent = 'Analyze Now';
        }
    });
    
    // Update stats
    async function updateStats() {
        try {
            const response = await fetch('api/get_data.php?action=stats');
            const data = await response.json();
            
            document.getElementById('rsiSymbols').textContent = data.rsiCount || 0;
            document.getElementById('lastUpdate').textContent = data.lastUpdate || '-';
        } catch (error) {
            console.error('Failed to update stats:', error);
        }
    }
    
    updateStats();
    setInterval(updateStats, 30000);
    </script>
</body>
</html>